/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.model;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import lotr.client.model.LOTRModelAngbandHelmet;
import lotr.client.model.LOTRModelArnorHelmet;
import lotr.client.model.LOTRModelBlackNumenoreanHelmet;
import lotr.client.model.LOTRModelBlackUrukHelmet;
import lotr.client.model.LOTRModelDorwinionElfHelmet;
import lotr.client.model.LOTRModelEasterlingHelmet;
import lotr.client.model.LOTRModelGaladhrimHelmet;
import lotr.client.model.LOTRModelGemsbokHelmet;
import lotr.client.model.LOTRModelGondolinHelmet;
import lotr.client.model.LOTRModelGondorHelmet;
import lotr.client.model.LOTRModelGulfChestplate;
import lotr.client.model.LOTRModelGundabadUrukHelmet;
import lotr.client.model.LOTRModelHaradRobes;
import lotr.client.model.LOTRModelHaradTurban;
import lotr.client.model.LOTRModelHarnedorChestplate;
import lotr.client.model.LOTRModelHarnedorHelmet;
import lotr.client.model.LOTRModelHeadPlate;
import lotr.client.model.LOTRModelHighElvenHelmet;
import lotr.client.model.LOTRModelLeatherHat;
import lotr.client.model.LOTRModelMoredainLionHelmet;
import lotr.client.model.LOTRModelMorgulHelmet;
import lotr.client.model.LOTRModelNearHaradWarlordHelmet;
import lotr.client.model.LOTRModelPartyHat;
import lotr.client.model.LOTRModelRohanMarshalHelmet;
import lotr.client.model.LOTRModelSwanChestplate;
import lotr.client.model.LOTRModelSwanHelmet;
import lotr.client.model.LOTRModelTauredainChieftainHelmet;
import lotr.client.model.LOTRModelTauredainGoldHelmet;
import lotr.client.model.LOTRModelUmbarHelmet;
import lotr.client.model.LOTRModelUrukHelmet;
import lotr.client.model.LOTRModelWingedHelmet;
import lotr.client.model.LOTRModelWizardHat;
import lotr.client.model.LOTRModelhelmetguldururuk;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemBanner;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRItemSling;
import lotr.common.item.LOTRItemSpear;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class LOTRArmorModels {
    public static LOTRArmorModels INSTANCE;
    private Map<ModelBiped, Map<Item, ModelBiped>> specialArmorModels = new HashMap<ModelBiped, Map<Item, ModelBiped>>();

    public static void setupArmorModels() {
        INSTANCE = new LOTRArmorModels();
    }

    private LOTRArmorModels() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private Map<Item, ModelBiped> getSpecialModels(ModelBiped key) {
        Map<Item, ModelBiped> map = this.specialArmorModels.get(key);
        if (map == null) {
            map = new HashMap<Item, ModelBiped>();
            map.put(LOTRMod.leatherHat, new LOTRModelLeatherHat());
            map.put(LOTRMod.helmetGondor, new LOTRModelGondorHelmet(1.0f));
            map.put(LOTRMod.gandalfhat, new LOTRModelWizardHat());
            map.put(LOTRMod.helmetElven, new LOTRModelGaladhrimHelmet(1.0f));
            map.put(LOTRMod.helmetGuldurUruk, new LOTRModelhelmetguldururuk(1.0f));
            map.put(LOTRMod.helmetguldururukberserk, new LOTRModelBlackUrukHelmet(1.0f));
            map.put(LOTRMod.helmetAngband, new LOTRModelAngbandHelmet(1.0f));
            map.put(LOTRMod.helmetangbande, new LOTRModelGundabadUrukHelmet(1.0f));
            map.put(LOTRMod.helmetGondorWinged, new LOTRModelWingedHelmet(1.0f));
            map.put(LOTRMod.helmetMorgul, new LOTRModelMorgulHelmet(1.0f));
            map.put(LOTRMod.helmetGemsbok, new LOTRModelGemsbokHelmet(1.0f));
            map.put(LOTRMod.helmetHighElven, new LOTRModelHighElvenHelmet(1.0f));
            map.put(LOTRMod.helmetBlackUruk, new LOTRModelBlackUrukHelmet(1.0f));
            map.put(LOTRMod.helmetUruk, new LOTRModelUrukHelmet(1.0f));
            map.put(LOTRMod.helmetNearHaradWarlord, new LOTRModelNearHaradWarlordHelmet(1.0f));
            map.put(LOTRMod.helmetDolAmroth, new LOTRModelSwanHelmet(1.0f));
            map.put(LOTRMod.bodyDolAmroth, new LOTRModelSwanChestplate(1.0f));
            map.put(LOTRMod.helmetMoredainLion, new LOTRModelMoredainLionHelmet(1.0f));
            map.put(LOTRMod.helmetHaradRobes, new LOTRModelHaradTurban());
            map.put(LOTRMod.bodyHaradRobes, new LOTRModelHaradRobes(1.0f));
            map.put(LOTRMod.legsHaradRobes, new LOTRModelHaradRobes(0.5f));
            map.put(LOTRMod.bootsHaradRobes, new LOTRModelHaradRobes(1.0f));
            map.put(LOTRMod.helmetGondolin, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetGalvorn, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetDain, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetEreborGoldCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetEreborSilverCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetEreborMithrilCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetDwarvenGoldCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetDwarvenSilverCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetDwarvenMithrilCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetBlueDwarvenGoldCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetBlueDwarvenSilverCommander, new LOTRModelGondolinHelmet(1.0f));
            map.put(LOTRMod.helmetRohanMarshal, new LOTRModelRohanMarshalHelmet(1.0f));
            map.put(LOTRMod.helmetTauredainChieftain, new LOTRModelTauredainChieftainHelmet(1.0f));
            map.put(LOTRMod.helmetTauredainGold, new LOTRModelTauredainGoldHelmet(1.0f));
            map.put(LOTRMod.helmetGundabadUruk, new LOTRModelGundabadUrukHelmet(1.0f));
            map.put(LOTRMod.helmetUrukBerserker, new LOTRModelUrukHelmet(1.0f));
            map.put(LOTRMod.helmetDorwinionElf, new LOTRModelDorwinionElfHelmet(1.0f));
            map.put(LOTRMod.partyHat, new LOTRModelPartyHat(0.6f));
            map.put(LOTRMod.helmetArnor, new LOTRModelArnorHelmet(1.0f));
            map.put(LOTRMod.helmetRhunGold, new LOTRModelEasterlingHelmet(1.0f, false));
            map.put(LOTRMod.helmetRhunWarlord, new LOTRModelEasterlingHelmet(1.0f, true));
            map.put(LOTRMod.helmetRivendell, new LOTRModelHighElvenHelmet(1.0f));
            map.put(LOTRMod.bodyGulfHarad, new LOTRModelGulfChestplate(1.0f));
            map.put(LOTRMod.helmetUmbar, new LOTRModelUmbarHelmet(1.0f));
            map.put(LOTRMod.helmetHarnedor, new LOTRModelHarnedorHelmet(1.0f));
            map.put(LOTRMod.bodyHarnedor, new LOTRModelHarnedorChestplate(1.0f));
            map.put(LOTRMod.helmetBlackNumenorean, new LOTRModelBlackNumenoreanHelmet(1.0f));
            map.put(LOTRMod.plate, new LOTRModelHeadPlate());
            map.put(LOTRMod.woodPlate, new LOTRModelHeadPlate());
            map.put(LOTRMod.ceramicPlate, new LOTRModelHeadPlate());
            map.put(LOTRMod.goldPlate, new LOTRModelHeadPlate());
            map.put(LOTRMod.mithrilPlate, new LOTRModelHeadPlate());
            for (ModelBiped armorModel : map.values()) {
                this.copyModelRotations(armorModel, key);
            }
            this.specialArmorModels.put(key, map);
        }
        return map;
    }

    public ModelBiped getSpecialArmorModel(ItemStack itemstack, int slot, EntityLivingBase entity, ModelBiped mainModel) {
        if (itemstack == null) {
            return null;
        }
        Item item = itemstack.func_77973_b();
        ModelBiped model = this.getSpecialModels(mainModel).get(item);
        if (model == null) {
            return null;
        }
        if (model instanceof LOTRModelLeatherHat) {
            ((LOTRModelLeatherHat)model).setHatItem(itemstack);
        }
        if (model instanceof LOTRModelHaradRobes) {
            ((LOTRModelHaradRobes)model).setRobeItem(itemstack);
        }
        if (model instanceof LOTRModelPartyHat) {
            ((LOTRModelPartyHat)model).setHatItem(itemstack);
        }
        if (model instanceof LOTRModelHeadPlate) {
            ((LOTRModelHeadPlate)model).setPlateItem(itemstack);
        }
        this.copyModelRotations(model, mainModel);
        this.setupArmorForSlot(model, slot);
        return model;
    }

    @SubscribeEvent
    public void getPlayerArmorModel(RenderPlayerEvent.SetArmorModel event) {
        RenderPlayer renderer = event.renderer;
        ModelBiped mainModel = renderer.field_77109_a;
        EntityPlayer entityplayer = event.entityPlayer;
        ItemStack armor = event.stack;
        int slot = event.slot;
        int result = this.getEntityArmorModel((RendererLivingEntity)renderer, mainModel, (EntityLivingBase)entityplayer, armor, 3 - slot);
        if (result > 0) {
            event.result = result;
        }
    }

    public int getEntityArmorModel(RendererLivingEntity renderer, ModelBiped mainModel, EntityLivingBase entity, ItemStack armor, int slot) {
        ModelBiped armorModel = this.getSpecialArmorModel(armor, slot, entity, mainModel);
        if (armorModel != null) {
            int color;
            Item armorItem;
            Item item = armorItem = armor == null ? null : armor.func_77973_b();
            if (armorItem instanceof ItemArmor) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(RenderBiped.getArmorResource((Entity)entity, (ItemStack)armor, (int)slot, null));
            }
            renderer.func_77042_a((ModelBase)armorModel);
            this.setupModelForRender(armorModel, mainModel, entity);
            if (armorItem instanceof ItemArmor && (color = ((ItemArmor)armorItem).func_82814_b(armor)) != -1) {
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor3f((float)r, (float)g, (float)b);
                if (armor.func_77948_v()) {
                    return 31;
                }
                return 16;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (armor.func_77948_v()) {
                return 15;
            }
            return 1;
        }
        return 0;
    }

    @SubscribeEvent
    public void preRenderEntity(RenderLivingEvent.Pre event) {
        EntityLivingBase entity = event.entity;
        RendererLivingEntity renderer = event.renderer;
        if (entity instanceof EntityPlayer && renderer instanceof RenderPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            RenderPlayer renderplayer = (RenderPlayer)renderer;
            ModelBiped mainModel = renderplayer.field_77109_a;
            ModelBiped armorModel1 = renderplayer.field_77108_b;
            ModelBiped armorModel2 = renderplayer.field_77111_i;
            this.setupModelForRender(mainModel, mainModel, (EntityLivingBase)entityplayer);
            this.setupModelForRender(armorModel1, mainModel, (EntityLivingBase)entityplayer);
            this.setupModelForRender(armorModel2, mainModel, (EntityLivingBase)entityplayer);
        }
    }

    public void setupModelForRender(ModelBiped model, ModelBiped mainModel, EntityLivingBase entity) {
        if (mainModel != null) {
            model.field_78095_p = mainModel.field_78095_p;
            model.field_78093_q = mainModel.field_78093_q;
            model.field_78091_s = mainModel.field_78091_s;
            model.field_78117_n = mainModel.field_78117_n;
        } else {
            model.field_78095_p = 0.0f;
            model.field_78093_q = false;
            model.field_78091_s = false;
            model.field_78117_n = false;
        }
        if (entity instanceof LOTREntityNPC) {
            model.field_78114_d.field_78806_j = ((LOTREntityNPC)entity).shouldRenderNPCHair();
        }
        if (entity instanceof EntityPlayer) {
            ItemStack heldRight = entity == null ? null : entity.func_70694_bm();
            model.field_78118_o = mainModel.field_78118_o;
            this.setupHeldItem(model, entity, heldRight, true);
        } else {
            ItemStack heldRight;
            ItemStack itemStack = heldRight = entity == null ? null : entity.func_70694_bm();
            ItemStack heldLeft = entity == null ? null : (entity instanceof LOTREntityNPC ? ((LOTREntityNPC)entity).getHeldItemLeft() : null);
            this.setupHeldItem(model, entity, heldRight, true);
            this.setupHeldItem(model, entity, heldLeft, false);
        }
    }

    private void setupHeldItem(ModelBiped model, EntityLivingBase entity, ItemStack itemstack, boolean rightArm) {
        int value = 0;
        boolean aimBow = false;
        if (itemstack != null) {
            value = 1;
            Item item = itemstack.func_77973_b();
            boolean isRanged = false;
            if (itemstack.func_77975_n() == EnumAction.bow) {
                boolean bl = item instanceof LOTRItemSpear ? entity instanceof EntityPlayer : (isRanged = !(item instanceof ItemSword));
            }
            if (item instanceof LOTRItemSling) {
                isRanged = true;
            }
            if (isRanged) {
                boolean aiming = model.field_78118_o;
                if (entity instanceof EntityPlayer && LOTRItemCrossbow.isLoaded(itemstack)) {
                    aiming = true;
                }
                if (entity instanceof LOTREntityNPC) {
                    aiming = ((LOTREntityNPC)entity).clientCombatStance;
                }
                if (aiming) {
                    value = 3;
                    aimBow = true;
                }
            }
            if (item instanceof LOTRItemBanner) {
                value = 3;
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_71052_bv() > 0 && itemstack.func_77975_n() == EnumAction.block) {
                value = 3;
            }
            if (entity instanceof LOTREntityNPC && ((LOTREntityNPC)entity).clientIsEating) {
                value = 3;
            }
        }
        if (rightArm) {
            model.field_78120_m = value;
            model.field_78118_o = aimBow;
        } else {
            model.field_78119_l = value;
        }
    }

    public void copyModelRotations(ModelBiped target, ModelBiped src) {
        this.copyBoxRotations(target.field_78116_c, src.field_78116_c);
        this.copyBoxRotations(target.field_78114_d, src.field_78114_d);
        this.copyBoxRotations(target.field_78115_e, src.field_78115_e);
        this.copyBoxRotations(target.field_78112_f, src.field_78112_f);
        this.copyBoxRotations(target.field_78113_g, src.field_78113_g);
        this.copyBoxRotations(target.field_78123_h, src.field_78123_h);
        this.copyBoxRotations(target.field_78124_i, src.field_78124_i);
    }

    public void copyBoxRotations(ModelRenderer target, ModelRenderer src) {
        target.field_78800_c = src.field_78800_c;
        target.field_78797_d = src.field_78797_d;
        target.field_78798_e = src.field_78798_e;
        target.field_78795_f = src.field_78795_f;
        target.field_78796_g = src.field_78796_g;
        target.field_78808_h = src.field_78808_h;
    }

    public void setupArmorForSlot(ModelBiped model, int slot) {
        model.field_78116_c.field_78806_j = slot == 0;
        model.field_78114_d.field_78806_j = slot == 0;
        model.field_78115_e.field_78806_j = slot == 1 || slot == 2;
        model.field_78112_f.field_78806_j = slot == 1;
        model.field_78113_g.field_78806_j = slot == 1;
        model.field_78123_h.field_78806_j = slot == 2 || slot == 3;
        model.field_78124_i.field_78806_j = slot == 2 || slot == 3;
    }
}

